<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WithdrawProof;
use App\Models\UserLedger;

class AdminWithdrawProofController extends Controller
{
    public function index()
    {
        $title = 'Withdraw Proof';
        $proofs = WithdrawProof::with('user')->latest()->get();

        return view('admin.withdraw_proofs.index', compact('proofs', 'title'));
    }

    public function updateStatus(Request $request, $id)
{
    $request->validate([
        'status' => 'required|in:approved,rejected',
    ]);

    $proof = WithdrawProof::findOrFail($id);

    if ($request->status === 'approved' && $proof->status !== 'approved') {
        $user = $proof->user;

        // ✅ Add reward
        $user->balance += $proof->reward_amount;
        $user->save();

        /*/ ✅ Add to ledger
        UserLedger::create([ 
            'user_id' => $user->id,
            'reason' => 'reward',
            'amount' => $proof->reward_amount,
            'perticulation' => 'Reward for approved withdrawal proof',
            //'reference_id' => $proof->id,
            //'reference_type' => WithdrawProof::class,
            //'balance_after' => $user->balance,
            'created_at' => now()
        ]);*/
    }

    // ✅ Update status
    $proof->status = $request->status;
    $proof->save();

    return back()->with('success', 'Proof status updated to ' . $request->status);
}

}
